<?php
if ( !function_exists( 'physc_set_post_views' ) ) {
	function physc_set_post_views( $postID ) {
		$count_key = 'phys_post_views_count';
		$count     = get_post_meta( $postID, $count_key, true );
		if ( $count == '' ) {
			$count = 0;
			delete_post_meta( $postID, $count_key );
			add_post_meta( $postID, $count_key, '0' );
		} else {
			$count ++;
			update_post_meta( $postID, $count_key, $count );
		}
	}
}

if ( !function_exists( 'physc_track_post_views' ) ) {
	function physc_track_post_views( $post_id ) {
		if ( !is_single() ) {
			return;
		}
		if ( empty ( $post_id ) ) {
			global $post;
			$post_id = $post->ID;
		}
		physc_set_post_views( $post_id );
	}

	add_action( 'wp_head', 'physc_track_post_views' );
}

if ( !function_exists( 'physc_get_post_views' ) ) {
	function physc_get_post_views( $postID ) {
		$count_key = 'phys_post_views_count';
		$count     = get_post_meta( $postID, $count_key, true );
		if ( $count == '' ) {
			delete_post_meta( $postID, $count_key );
			add_post_meta( $postID, $count_key, '0' );

			return '<span class="count-view"><i class="fa fa-eye"></i>0</span>';
		}

		return '<span class="count-view"><i class="fa fa-eye"></i>' . $count . '</span>';
	}
}